// import multer from 'multer';
// import expFil from 'express-fileupload'

// const storage = multer.memoryStorage()
// export const multerUpload = multer({ 
//     storage: storage,
//     // limits: {
//     //     fileSize: 10 * 1024 * 1024, // Limit file size to 10MB
//     //     fieldSize: 2 * 1024 * 1024  // Limit non-file field size to 2MB
//     // }
// });

// // export const expressUpload = 


import multer from 'multer';
import { NextFunction, Request, Response } from 'express';
import path from 'path';
import fs from 'fs';

// Define allowed file types
const allowedFileTypes = ['application/pdf', 'image/jpeg', 'image/png'];

// const storage = multer.memoryStorage();
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        // const uploadDir = path.join(__dirname, process.env.UPLOAD_PATH ?? 'uploads'); // Change to your desired directory
      const uploadDir = path.join(process.env.UPLOAD_PATH ?? 'public/uploads'); // Change to your desired directory
      // Ensure that the directory exists
      if (!fs.existsSync(uploadDir)) {
        fs.mkdirSync(uploadDir);
      }
      cb(null, uploadDir);
    },
    filename: (req, file, cb) => {
      const uniqueName = `${Date.now()}-${file.originalname}`;
      cb(null, uniqueName); // You can use any naming strategy here
    }
  });

// Define the fileFilter function to check file type
const fileFilter = (req: any, file: any, cb: any) => {
  if (allowedFileTypes.includes(file.mimetype)) {
    cb(null, true);
  } else {
    cb(new Error('Invalid file type. Only PDF, JPEG, and PNG are allowed.'), false);
  }
};

export const multerUpload = multer({
  storage: storage,
  limits: {
    fileSize: 500 * 1024 // Limit file size to 500KB
  },
  fileFilter: fileFilter
});

// Custom error handling middleware for file size
export const fileUploadErrorHandler = (err: any, req: Request, res: Response, next: NextFunction) => {
  // Log the error for debugging
  console.error(err, 'INSIDE multer file');

  // Handle Multer's specific errors
  if (err instanceof multer.MulterError) {
    switch (err.code) {
      case 'LIMIT_FILE_SIZE':
        console.log('herf')
        return res.status(400).json({ error: `File size exceeds the 500KB limit at ${err.field}`, message: `File size exceeds the 500KB limit at ${err.field}` });
      default:
        return res.status(400).json({ error: `Multer error: ${err.message}`, message: err.message });
    }
  }

  // Handle other types of errors (e.g., invalid file type)
  if (err.message) {
    return res.status(400).json({ error: err.message, message: err.message });
  }

  // If the error is unhandled, pass it to the next error handler
  next(err);
};
